document.addEventListener('DOMContentLoaded', function() {
    console.log('Congratulations page loaded successfully');
    
    // Test button - navigate to test page
    const testText = document.querySelector('.test-text');
    const testVectorLeft = document.querySelector('.test-vector-left');
    const testVectorRight = document.querySelector('.test-vector-right');
    
    function navigateToTest() {
        console.log('Test button clicked, navigating to test page...');
        window.location.href = 'test.html';
    }
    
    if (testText) {
        testText.style.cursor = 'pointer';
        testText.addEventListener('click', navigateToTest);
    }
    if (testVectorLeft) {
        testVectorLeft.style.cursor = 'pointer';
        testVectorLeft.addEventListener('click', navigateToTest);
    }
    if (testVectorRight) {
        testVectorRight.style.cursor = 'pointer';
        testVectorRight.addEventListener('click', navigateToTest);
    }
    
    // Back button - navigate to MacBook Air 2 (index.html)
    const backText = document.querySelector('.back-text');
    const backVectorLeft = document.querySelector('.back-vector-left');
    const backVectorRight = document.querySelector('.back-vector-right');
    
    function navigateToIndex() {
        console.log('Back button clicked, navigating to index page (MacBook Air 2)...');
        window.location.href = 'index.html';
    }
    
    if (backText) {
        backText.style.cursor = 'pointer';
        backText.addEventListener('click', navigateToIndex);
    }
    if (backVectorLeft) {
        backVectorLeft.style.cursor = 'pointer';
        backVectorLeft.addEventListener('click', navigateToIndex);
    }
    if (backVectorRight) {
        backVectorRight.style.cursor = 'pointer';
        backVectorRight.addEventListener('click', navigateToIndex);
    }
});
